
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


/** An instance is a window with text */
public class TextWindow extends JFrame {
	
   /** Constructor: A window with title and text. The text
       field used is cols columns wide */
	public TextWindow(String text, String title, int cols) {
		Container contents= getContentPane();
		setTitle(title);
      contents.add(BorderLayout.NORTH,new JLabel(title));
		// add text field
			JTextField textField= new JTextField(text, cols);
			textField.setEditable(false);
			contents.add(BorderLayout.CENTER,textField);
		// add ok button
			JButton ok= new JButton("Ok");
		   ok.addActionListener(new OkActionListener());
			contents.add(BorderLayout.SOUTH,ok);
		// add window closing event handler
		    addWindowListener(new WindowAdapter() {
		  	   public void windowClosing(WindowEvent e) {
				   closeWindow();
			  }});
		// finalize frame
			pack();
			setVisible(true);
	}
		  

	/** Close window */
	public void closeWindow() {
		dispose();
	}

	/** Handle press of button ok */
	class OkActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			  closeWindow();
		}
	}
}
		   

